import { useEditor } from "@tldraw/editor";
import { useCallback } from "react";
import { exportAs } from "../../utils/export/exportAs.mjs";
import { useToasts } from "../context/toasts.mjs";
import { useTranslation } from "./useTranslation/useTranslation.mjs";
function useExportAs() {
  const editor = useEditor();
  const { addToast } = useToasts();
  const msg = useTranslation();
  return useCallback(
    (ids, format = "png", name) => {
      exportAs(editor, ids, format, name, {
        scale: 1,
        background: editor.getInstanceState().exportBackground
      }).catch((e) => {
        console.error(e.message);
        addToast({
          id: "export-fail",
          title: msg("toast.error.export-fail.title"),
          description: msg("toast.error.export-fail.desc"),
          severity: "error"
        });
      });
    },
    [editor, addToast, msg]
  );
}
export {
  useExportAs
};
//# sourceMappingURL=useExportAs.mjs.map
